/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.fabric.storage;

import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.common.lib.HexBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0013\u0010\rJ\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lat/petrak/hexcasting/fabric/storage/FabricImpetusStorage;", "Lnet/fabricmc/fabric/api/transfer/v1/storage/base/SingleSlotStorage;", "Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;", "Lat/petrak/hexcasting/api/casting/circles/BlockEntityAbstractImpetus;", "impetus", "<init>", "(Lat/petrak/hexcasting/api/casting/circles/BlockEntityAbstractImpetus;)V", "resource", "", "maxAmount", "Lnet/fabricmc/fabric/api/transfer/v1/transaction/TransactionContext;", "transaction", "extract", "(Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;JLnet/fabricmc/fabric/api/transfer/v1/transaction/TransactionContext;)J", "getAmount", "()J", "getCapacity", "getResource", "()Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;", "insert", "", "isResourceBlank", "()Z", "supportsExtraction", "Lat/petrak/hexcasting/api/casting/circles/BlockEntityAbstractImpetus;", "getImpetus", "()Lat/petrak/hexcasting/api/casting/circles/BlockEntityAbstractImpetus;", "Companion", "hexcasting-fabric-1.20.1"})
public final class FabricImpetusStorage
implements SingleSlotStorage<ItemVariant> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockEntityAbstractImpetus impetus;

    public FabricImpetusStorage(@NotNull BlockEntityAbstractImpetus impetus) {
        Intrinsics.checkNotNullParameter((Object)((Object)impetus), (String)"impetus");
        this.impetus = impetus;
    }

    @NotNull
    public final BlockEntityAbstractImpetus getImpetus() {
        return this.impetus;
    }

    public long insert(@NotNull ItemVariant resource, long maxAmount, @NotNull TransactionContext transaction) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        long stackCount = maxAmount / (long)64;
        int remainder = (int)(maxAmount % (long)64);
        Ref.LongRef mediaToTake = new Ref.LongRef();
        mediaToTake.element = this.impetus.remainingMediaCapacity();
        Ref.LongRef itemsConsumed = new Ref.LongRef();
        for (long i = 0L; i < stackCount; ++i) {
            class_1799 stack = resource.toStack(64);
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            FabricImpetusStorage.insert$insertStack(this, mediaToTake, itemsConsumed, stack, transaction);
            if (mediaToTake.element > 0L) continue;
            return itemsConsumed.element;
        }
        if (remainder > 0) {
            class_1799 remainderStack = resource.toStack(remainder);
            Intrinsics.checkNotNullExpressionValue((Object)remainderStack, (String)"remainderStack");
            FabricImpetusStorage.insert$insertStack(this, mediaToTake, itemsConsumed, remainderStack, transaction);
        }
        return itemsConsumed.element;
    }

    public boolean supportsExtraction() {
        return false;
    }

    public long extract(@NotNull ItemVariant resource, long maxAmount, @NotNull TransactionContext transaction) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return 0L;
    }

    public boolean isResourceBlank() {
        return true;
    }

    @NotNull
    public ItemVariant getResource() {
        ItemVariant itemVariant = ItemVariant.blank();
        Intrinsics.checkNotNullExpressionValue((Object)itemVariant, (String)"blank()");
        return itemVariant;
    }

    public long getAmount() {
        return 0L;
    }

    public long getCapacity() {
        return 64L;
    }

    private static final void insert$insertStack$lambda$0(FabricImpetusStorage this$0, class_1799 $copied, TransactionContext.Result it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (it.wasCommitted()) {
            this$0.impetus.insertMedia($copied);
        }
    }

    private static final void insert$insertStack(FabricImpetusStorage this$0, Ref.LongRef mediaToTake, Ref.LongRef itemsConsumed, class_1799 stack, TransactionContext transaction) {
        class_1799 copied = stack.method_7972();
        int size = stack.method_7947();
        long extractable = this$0.impetus.extractMediaFromInsertedItem(stack, false);
        mediaToTake.element -= extractable;
        int taken = size - stack.method_7947();
        itemsConsumed.element += (long)taken;
        copied.method_7939(taken);
        if (taken > 0) {
            transaction.addOuterCloseCallback(arg_0 -> FabricImpetusStorage.insert$insertStack$lambda$0(this$0, copied, arg_0));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lat/petrak/hexcasting/fabric/storage/FabricImpetusStorage$Companion;", "", "<init>", "()V", "", "registerStorage", "hexcasting-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerStorage() {
            class_2248[] class_2248Array = new class_2248[]{HexBlocks.IMPETUS_RIGHTCLICK, HexBlocks.IMPETUS_LOOK, HexBlocks.IMPETUS_REDSTONE};
            ItemStorage.SIDED.registerForBlocks(Companion::registerStorage$lambda$0, class_2248Array);
        }

        private static final Storage registerStorage$lambda$0(class_1937 class_19372, class_2338 class_23382, class_2680 class_26802, class_2586 blockEntity, class_2350 class_23502) {
            FabricImpetusStorage fabricImpetusStorage;
            BlockEntityAbstractImpetus blockEntityAbstractImpetus = blockEntity instanceof BlockEntityAbstractImpetus ? (BlockEntityAbstractImpetus)blockEntity : null;
            if (blockEntityAbstractImpetus != null) {
                BlockEntityAbstractImpetus p0 = blockEntityAbstractImpetus;
                boolean bl = false;
                fabricImpetusStorage = new FabricImpetusStorage(p0);
            } else {
                fabricImpetusStorage = null;
            }
            return (Storage)fabricImpetusStorage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

